#pragma once
#include <Arduino.h>

// เลือกรูปแบบการขับมอเตอร์ (ครึ่งสเต็ป / เต็มสเต็ป)
enum step_mode_t { HALF_STEP, FULL_STEP };

class Stepper28 {
public:
  // กำหนดขาควบคุม 4 เส้น และโหมด (ค่าเริ่มต้นคือ HALF_STEP)
  Stepper28(uint8_t in1, uint8_t in2, uint8_t in3, uint8_t in4, step_mode_t mode = HALF_STEP);

  void begin();                    // เรียกใน setup() เพื่อเตรียมขา
  void setSpeed(int rpm);          // ตั้งความเร็วรอบต่อนาที
  void stop();                     // หยุดการหมุนทันที

  void stepCW(float value);        // หมุนตามเข็มนาฬิกา (ใส่จำนวนรอบหรือจำนวนสเต็ป)
  void stepCCW(float value);       // หมุนทวนเข็มนาฬิกา (ใส่จำนวนรอบหรือจำนวนสเต็ป)
  void spinCW(int rpm);            // หมุนต่อเนื่องตามเข็มนาฬิกา
  void spinCCW(int rpm);           // หมุนต่อเนื่องทวนเข็มนาฬิกา

  void moveSteps(long steps);               // หมุนตามจำนวนสเต็ป (เชิงตำแหน่ง)
  void moveSteps(long steps, int rpm);      // หมุนตามจำนวนสเต็ปพร้อมตั้ง rpm
  void goTo(long pos);                      // หมุนไปตำแหน่งเป้าหมาย (absolute)
  void goTo(long pos, int rpm);             // หมุนไปตำแหน่งเป้าหมายพร้อมตั้ง rpm

  long  getPos() const { return _pos; }     // คืนค่าตำแหน่งปัจจุบัน
  void  setHome()      { _pos = 0; }        // ตั้งตำแหน่งปัจจุบันเป็นจุดเริ่มต้น (home)
  long  distanceToGo() const { return _targetActive ? (_targetPos - _pos) : 0; }  // ระยะที่เหลือ
  bool  isRunning() const { return _dir != 0 || _targetActive; }  // ตรวจสอบว่ากำลังหมุนอยู่หรือไม่

  static void isrHandler();                 // เรียกจาก ISR (Timer interrupt)

private:
  void oneStep(int dir);                    // หมุน 1 สเต็ปตามทิศทาง
  void writePhaseIdx(uint32_t idx);         // ส่งสัญญาณไปที่ขามอเตอร์ตามตารางเฟส
  void applyTimerFromRPM();                 // คำนวณค่า Timer จากความเร็ว
  void enableTimer();                       // เปิดใช้งาน Timer
  void disableTimer();                      // ปิดใช้งาน Timer

  uint8_t _in1,_in2,_in3,_in4;              // ขาเชื่อมต่อ
  volatile int8_t  _dir = 0;                // ทิศทางหมุน (-1=CCW, 0=หยุด, 1=CW)
  volatile uint32_t _seqPos = 0;            // ลำดับขั้นตอนในตารางเฟส

  step_mode_t _mode = HALF_STEP;            // โหมดสเต็ป
  uint32_t _stepsPerRev = 4096;             // จำนวนสเต็ปต่อรอบ (half step)
  uint8_t  _seqLen     = 8;                 // จำนวนชุดลำดับในตาราง
  int      _rpm        = 10;                // ความเร็วปัจจุบัน (รอบ/นาที)

  volatile long _pos = 0;                   // ตำแหน่งปัจจุบัน (step)
  volatile bool _targetActive = false;      // สถานะว่ามีเป้าหมายหรือไม่
  volatile long _targetPos = 0;             // เป้าหมายตำแหน่งที่จะไป

  static const uint8_t SEQ_HALF[8][4];      // ตารางขับ half step
  static const uint8_t SEQ_FULL[4][4];      // ตารางขับ full step
  static Stepper28* _inst;                  // ตัวชี้อินสแตนซ์ (ใช้ใน ISR)
  volatile uint32_t _ocrValue = 0;          // ค่า OCR1A สำหรับ Timer (AVR)
};
